/******************************************************* 
Filename		:  alter_station_project_table.sql 
Description		:  Adds station weight columns to station_project,
				   grants select to storetweb on station_project 
Author			:  Sree Rayankula 
Date			:  05/16/2006 
Comments        :
**********************************************************/ 
spool alter_station_project.log
set serveroutput on;

begin

begin
execute immediate
		'alter table station_project ' ||
		'add   (STATION_WEIGHT VARCHAR2(256 CHAR), ' ||
		'		WEIGHT_UNIT_CODE VARCHAR2(256 CHAR), ' ||
		'		STRATUM VARCHAR2(256 CHAR), ' ||
		'		STATION_WEIGHT_CATEGORY VARCHAR2(256 CHAR), ' ||
		'		SITE_STATUS VARCHAR2(256 CHAR) )';
		
execute immediate 'COMMENT ON COLUMN STATION_PROJECT.STATION_WEIGHT IS ''Project station weight''';
execute immediate 'COMMENT ON COLUMN STATION_PROJECT.WEIGHT_UNIT_CODE IS ''Station weight unit code.''';
execute immediate 'COMMENT ON COLUMN STATION_PROJECT.STRATUM IS ''Station weight stratum''';
execute immediate 'COMMENT ON COLUMN STATION_PROJECT.STATION_WEIGHT_CATEGORY IS ''Station weight category''';
execute immediate 'COMMENT ON COLUMN STATION_PROJECT.SITE_STATUS IS ''Station weight site status''';
exception when others then null;
end;

execute immediate 'grant select on station_project to storetweb';
execute immediate 'grant select on di_project to storetweb';
end;
/
spool off;

